/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.ae2wtlib.api.networking;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import p455w0rd.ae2wtlib.api.networking.WTPacket;
import p455w0rd.ae2wtlib.sync.packets.PacketBaubleSync;
import p455w0rd.ae2wtlib.sync.packets.PacketConfigSync;
import p455w0rd.ae2wtlib.sync.packets.PacketEmptyTrash;
import p455w0rd.ae2wtlib.sync.packets.PacketSetAutoConsumeBoosters;
import p455w0rd.ae2wtlib.sync.packets.PacketSetInRange;
import p455w0rd.ae2wtlib.sync.packets.PacketSwapSlots;
import p455w0rd.ae2wtlib.sync.packets.PacketSyncInfinityEnergy;

public class WTPacketHandlerBase {
    private static final Map<Class<? extends WTPacket>, PacketTypes> REVERSE_LOOKUP = new HashMap<Class<? extends WTPacket>, PacketTypes>();

    public static enum PacketTypes {
        PACKET_SWAP_SLOTS(PacketSwapSlots.class),
        PACKET_EMPTY_TRASH(PacketEmptyTrash.class),
        PACKET_SYNC_CONFIGS(PacketConfigSync.class),
        PACKET_SYNC_INFINITY_ENERGY(PacketSyncInfinityEnergy.class),
        PACKET_SET_IN_RANGE(PacketSetInRange.class),
        PACKET_SET_AUTOCONSUME_BOOSTERS(PacketSetAutoConsumeBoosters.class),
        PACKET_BAUBLE_SYNC(PacketBaubleSync.class);

        private final Class<? extends WTPacket> packetClass;
        private final Constructor<? extends WTPacket> packetConstructor;

        private PacketTypes(Class<? extends WTPacket> c) {
            this.packetClass = c;
            Constructor<? extends WTPacket> x = null;
            try {
                x = this.packetClass.getConstructor(ByteBuf.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            catch (DecoderException decoderException) {
                // empty catch block
            }
            this.packetConstructor = x;
            REVERSE_LOOKUP.put(this.packetClass, this);
            if (this.packetConstructor == null) {
                throw new IllegalStateException("Invalid Packet Class " + c + ", must be constructable on DataInputStream");
            }
        }

        public static PacketTypes getPacket(int id) {
            return PacketTypes.values()[id];
        }

        static PacketTypes getID(Class<? extends WTPacket> c) {
            return (PacketTypes)((Object)REVERSE_LOOKUP.get(c));
        }

        public WTPacket parsePacket(ByteBuf in) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.packetConstructor.newInstance(in);
        }
    }
}

