/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.tile.IPhantomTile;
import de.ellpeck.actuallyadditions.mod.blocks.BlockPhantom;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityPhantomface
extends TileEntityInventoryBase
implements IPhantomTile {
    public static final int RANGE = 16;
    public BlockPos boundPosition;
    public BlockPhantom.Type type;
    public int range;
    private int rangeBefore;
    private BlockPos boundPosBefore;
    private Block boundBlockBefore;
    private int lastStrength;

    public TileEntityPhantomface(String name) {
        super(0, name);
    }

    public static int upgradeRange(int defaultRange, World world, BlockPos pos) {
        Block block;
        int newRange = defaultRange;
        for (int i = 0; i < 3 && (block = world.func_180495_p(pos.func_177981_b(1 + i)).func_177230_c()) == InitBlocks.blockPhantomBooster; ++i) {
            newRange *= 2;
        }
        return newRange;
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("Range", this.range);
            if (this.boundPosition != null) {
                compound.func_74768_a("xOfTileStored", this.boundPosition.func_177958_n());
                compound.func_74768_a("yOfTileStored", this.boundPosition.func_177956_o());
                compound.func_74768_a("zOfTileStored", this.boundPosition.func_177952_p());
            }
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            int x = compound.func_74762_e("xOfTileStored");
            int y = compound.func_74762_e("yOfTileStored");
            int z = compound.func_74762_e("zOfTileStored");
            this.range = compound.func_74762_e("Range");
            if (x != 0 || y != 0 || z != 0) {
                this.boundPosition = new BlockPos(x, y, z);
                this.func_70296_d();
            }
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            int strength;
            this.range = TileEntityPhantomface.upgradeRange(16, this.field_145850_b, this.func_174877_v());
            if (!this.hasBoundPosition()) {
                this.boundPosition = null;
            }
            if (this.doesNeedUpdateSend()) {
                this.onUpdateSent();
            }
            if (this.lastStrength != (strength = this.getComparatorStrength())) {
                this.lastStrength = strength;
                this.func_70296_d();
            }
        } else if (this.boundPosition != null) {
            this.renderParticles();
        }
    }

    protected boolean doesNeedUpdateSend() {
        return this.boundPosition != this.boundPosBefore || this.boundPosition != null && this.field_145850_b.func_180495_p(this.boundPosition).func_177230_c() != this.boundBlockBefore || this.rangeBefore != this.range;
    }

    protected void onUpdateSent() {
        this.rangeBefore = this.range;
        this.boundPosBefore = this.boundPosition;
        Block block = this.boundBlockBefore = this.boundPosition == null ? null : this.field_145850_b.func_180495_p(this.boundPosition).func_177230_c();
        if (this.boundPosition != null) {
            this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145850_b.func_180495_p(this.boundPosition).func_177230_c(), false);
        }
        this.sendUpdate();
        this.func_70296_d();
    }

    @Override
    public boolean hasBoundPosition() {
        if (this.boundPosition != null) {
            if (this.field_145850_b.func_175625_s(this.boundPosition) instanceof IPhantomTile || this.func_174877_v().func_177958_n() == this.boundPosition.func_177958_n() && this.func_174877_v().func_177956_o() == this.boundPosition.func_177956_o() && this.func_174877_v().func_177952_p() == this.boundPosition.func_177952_p()) {
                this.boundPosition = null;
                return false;
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderParticles() {
        if (this.field_145850_b.field_73012_v.nextInt(2) == 0) {
            double d1 = (float)this.boundPosition.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat();
            int i1 = this.field_145850_b.field_73012_v.nextInt(2) * 2 - 1;
            int j1 = this.field_145850_b.field_73012_v.nextInt(2) * 2 - 1;
            double d4 = ((double)this.field_145850_b.field_73012_v.nextFloat() - 0.5) * 0.125;
            double d2 = (double)this.boundPosition.func_177952_p() + 0.5 + 0.25 * (double)j1;
            double d5 = this.field_145850_b.field_73012_v.nextFloat() * 1.0f * (float)j1;
            double d0 = (double)this.boundPosition.func_177958_n() + 0.5 + 0.25 * (double)i1;
            double d3 = this.field_145850_b.field_73012_v.nextFloat() * 1.0f * (float)i1;
            this.field_145850_b.func_175688_a(EnumParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5, new int[0]);
        }
    }

    @Override
    public boolean isBoundThingInRange() {
        return this.hasBoundPosition() && this.boundPosition.func_177951_i((Vec3i)this.func_174877_v()) <= (double)(this.range * this.range);
    }

    @Override
    public BlockPos getBoundPosition() {
        return this.boundPosition;
    }

    @Override
    public void setBoundPosition(BlockPos pos) {
        this.boundPosition = pos;
    }

    @Override
    public int getGuiID() {
        return -1;
    }

    @Override
    public int getRange() {
        return this.range;
    }

    protected abstract boolean isCapabilitySupported(Capability<?> var1);

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        TileEntity tile;
        if (this.isBoundThingInRange() && this.isCapabilitySupported(capability) && (tile = this.field_145850_b.func_175625_s(this.getBoundPosition())) != null) {
            return tile.hasCapability(capability, facing);
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        TileEntity tile;
        if (this.isBoundThingInRange() && this.isCapabilitySupported(capability) && (tile = this.field_145850_b.func_175625_s(this.getBoundPosition())) != null) {
            return (T)tile.getCapability(capability, facing);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public int getComparatorStrength() {
        BlockPos pos;
        IBlockState state;
        if (this.isBoundThingInRange() && (state = this.field_145850_b.func_180495_p(pos = this.getBoundPosition())).func_185912_n()) {
            return state.func_185888_a(this.field_145850_b, pos);
        }
        return 0;
    }
}

