/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.config.values.ConfigStringListValues;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomface;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityMiner
extends TileEntityInventoryBase
implements IButtonReactor,
IEnergyDisplay {
    public static final int ENERGY_USE_PER_BLOCK = 650;
    public static final int DEFAULT_RANGE = 2;
    public final CustomEnergyStorage storage = new CustomEnergyStorage(200000, 2000, 0);
    public boolean onlyMineOres;
    public int checkX;
    public int checkY = -1;
    public int checkZ;
    private int oldEnergy;
    private int oldCheckX;
    private int oldCheckY;
    private int oldCheckZ;

    public TileEntityMiner() {
        super(9, "miner");
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("CheckX", this.checkX);
            compound.func_74768_a("CheckY", this.checkY);
            compound.func_74768_a("CheckZ", this.checkZ);
        }
        if (type != TileEntityBase.NBTType.SAVE_BLOCK || this.onlyMineOres) {
            compound.func_74757_a("OnlyOres", this.onlyMineOres);
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.checkX = compound.func_74762_e("CheckX");
            this.checkY = compound.func_74762_e("CheckY");
            this.checkZ = compound.func_74762_e("CheckZ");
        }
        this.onlyMineOres = compound.func_74767_n("OnlyOres");
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isRedstonePowered && this.ticksElapsed % 5 == 0 && this.checkY != 0) {
                int range = TileEntityPhantomface.upgradeRange(2, this.field_145850_b, this.field_174879_c);
                if (this.checkY < 0) {
                    this.checkY = this.field_174879_c.func_177956_o() - 1;
                    this.checkX = -range;
                    this.checkZ = -range;
                }
                if (this.checkY > 0 && this.mine()) {
                    ++this.checkX;
                    if (this.checkX > range) {
                        this.checkX = -range;
                        ++this.checkZ;
                        if (this.checkZ > range) {
                            this.checkZ = -range;
                            --this.checkY;
                        }
                    }
                }
            }
            if ((this.oldEnergy != this.storage.getEnergyStored() || this.oldCheckX != this.checkX || this.oldCheckY != this.checkY || this.oldCheckZ != this.checkZ) && this.sendUpdateWithInterval()) {
                this.oldEnergy = this.storage.getEnergyStored();
                this.oldCheckX = this.checkX;
                this.oldCheckY = this.checkY;
                this.oldCheckZ = this.checkZ;
            }
        }
    }

    private boolean mine() {
        int actualUse = 650 * (this.onlyMineOres ? 3 : 1);
        if (this.storage.getEnergyStored() >= actualUse) {
            BlockPos pos = new BlockPos(this.field_174879_c.func_177958_n() + this.checkX, this.checkY, this.field_174879_c.func_177952_p() + this.checkZ);
            IBlockState state = this.field_145850_b.func_180495_p(pos);
            Block block = state.func_177230_c();
            ItemStack stack = block.getPickBlock(state, new RayTraceResult(RayTraceResult.Type.BLOCK, new Vec3d(0.0, 0.0, 0.0), EnumFacing.DOWN, pos), this.field_145850_b, pos, (EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.field_145850_b)));
            if (!block.isAir(this.field_145850_b.func_180495_p(pos), (IBlockAccess)this.field_145850_b, pos) && block.getHarvestLevel(this.field_145850_b.func_180495_p(pos)) <= 4 && state.func_185887_b(this.field_145850_b, pos) >= 0.0f && !(block instanceof BlockLiquid) && !(block instanceof IFluidBlock) && this.isMinable(block, stack)) {
                NonNullList drops = NonNullList.func_191196_a();
                block.getDrops(drops, (IBlockAccess)this.field_145850_b, pos, state, 0);
                float chance = WorldUtil.fireFakeHarvestEventsForDropChance((NonNullList<ItemStack>)drops, this.field_145850_b, pos);
                if (chance > 0.0f && this.field_145850_b.field_73012_v.nextFloat() <= chance) {
                    if (StackUtil.canAddAll(this.inv, (List<ItemStack>)drops, false)) {
                        this.field_145850_b.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)this.field_145850_b.func_180495_p(pos)));
                        this.field_145850_b.func_175698_g(pos);
                        StackUtil.addAll(this.inv, (List<ItemStack>)drops, false);
                        this.func_70296_d();
                        this.storage.extractEnergyInternal(actualUse, false);
                        this.shootParticles(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    } else {
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean isMinable(Block block, ItemStack stack) {
        if (block != null && !this.isBlacklisted(block)) {
            if (!this.onlyMineOres) {
                return true;
            }
            if (StackUtil.isValid(stack)) {
                int[] ids;
                for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
                    String name = OreDictionary.getOreName((int)id);
                    if (!name.startsWith("ore") && !name.startsWith("denseore")) continue;
                    return true;
                }
                String reg = block.getRegistryName().toString();
                if (!reg.isEmpty()) {
                    for (String string : ConfigStringListValues.MINER_EXTRA_WHITELIST.getValue()) {
                        if (!reg.equals(string)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void shootParticles(int endX, int endY, int endZ) {
        AssetUtil.spawnLaserWithTimeServer(this.field_145850_b, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), endX, endY, endZ, new float[]{0.25490198f, 0.5882353f, 0.007843138f}, 10, 120.0, 0.1f, 0.8f);
    }

    private boolean isBlacklisted(Block block) {
        String reg = block.getRegistryName().toString();
        if (!reg.isEmpty()) {
            for (String string : ConfigStringListValues.MINER_BLACKLIST.getValue()) {
                if (!reg.equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (stack, slot, automation) -> !automation;
    }

    @Override
    public void onButtonPressed(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            this.onlyMineOres = !this.onlyMineOres;
            this.sendUpdate();
        } else if (buttonID == 1) {
            this.checkX = 0;
            this.checkY = -1;
            this.checkZ = 0;
        }
    }

    @Override
    public CustomEnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public boolean needsHoldShift() {
        return false;
    }

    @Override
    public IEnergyStorage getEnergyStorage(EnumFacing facing) {
        return this.storage;
    }
}

