/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.network;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.booklet.IBookletChapter;
import de.ellpeck.actuallyadditions.mod.booklet.chapter.BookletChapterTrials;
import de.ellpeck.actuallyadditions.mod.data.PlayerData;
import de.ellpeck.actuallyadditions.mod.network.PacketClientToServer;
import de.ellpeck.actuallyadditions.mod.network.PacketHandler;
import de.ellpeck.actuallyadditions.mod.network.PacketServerToClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class PacketHandlerHelper {
    @SideOnly(value=Side.CLIENT)
    public static void sendButtonPacket(TileEntity tile, int buttonId) {
        NBTTagCompound compound = new NBTTagCompound();
        BlockPos pos = tile.func_174877_v();
        compound.func_74768_a("X", pos.func_177958_n());
        compound.func_74768_a("Y", pos.func_177956_o());
        compound.func_74768_a("Z", pos.func_177952_p());
        compound.func_74768_a("WorldID", tile.func_145831_w().field_73011_w.getDimension());
        compound.func_74768_a("PlayerID", Minecraft.func_71410_x().field_71439_g.func_145782_y());
        compound.func_74768_a("ButtonID", buttonId);
        PacketHandler.theNetwork.sendToServer((IMessage)new PacketClientToServer(compound, PacketHandler.GUI_BUTTON_TO_TILE_HANDLER));
    }

    public static void syncPlayerData(EntityPlayer player, boolean log) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("Log", log);
        NBTTagCompound data = new NBTTagCompound();
        PlayerData.getDataFromPlayer(player).writeToNBT(data, false);
        compound.func_74782_a("Data", (NBTBase)data);
        if (player instanceof EntityPlayerMP) {
            PacketHandler.theNetwork.sendTo((IMessage)new PacketServerToClient(compound, PacketHandler.SYNC_PLAYER_DATA), (EntityPlayerMP)player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendPlayerDataToServer(boolean log, int type) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("Log", log);
        compound.func_74768_a("Type", type);
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            compound.func_74768_a("World", player.field_70170_p.field_73011_w.getDimension());
            compound.func_186854_a("UUID", player.func_110124_au());
            PlayerData.PlayerSave data = PlayerData.getDataFromPlayer((EntityPlayer)player);
            if (type == 0) {
                compound.func_74782_a("Bookmarks", (NBTBase)data.saveBookmarks());
            } else if (type == 1) {
                compound.func_74757_a("DidBookTutorial", data.didBookTutorial);
            } else if (type == 2) {
                compound.func_74782_a("Trials", (NBTBase)data.saveTrials());
                int total = 0;
                for (IBookletChapter chapter : ActuallyAdditionsAPI.entryTrials.getAllChapters()) {
                    if (!(chapter instanceof BookletChapterTrials)) continue;
                    ++total;
                }
                if (data.completedTrials.size() >= total) {
                    compound.func_74757_a("Achievement", true);
                }
            }
            PacketHandler.theNetwork.sendToServer((IMessage)new PacketClientToServer(compound, PacketHandler.PLAYER_DATA_TO_SERVER));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendNumberPacket(TileEntity tile, double number, int id) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("X", tile.func_174877_v().func_177958_n());
        compound.func_74768_a("Y", tile.func_174877_v().func_177956_o());
        compound.func_74768_a("Z", tile.func_174877_v().func_177952_p());
        compound.func_74768_a("WorldID", tile.func_145831_w().field_73011_w.getDimension());
        compound.func_74768_a("PlayerID", Minecraft.func_71410_x().field_71439_g.func_145782_y());
        compound.func_74768_a("NumberID", id);
        compound.func_74780_a("Number", number);
        PacketHandler.theNetwork.sendToServer((IMessage)new PacketClientToServer(compound, PacketHandler.GUI_NUMBER_TO_TILE_HANDLER));
    }
}

