/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc.apiimpl;

import de.ellpeck.actuallyadditions.api.laser.IConnectionPair;
import de.ellpeck.actuallyadditions.api.laser.ILaserRelayConnectionHandler;
import de.ellpeck.actuallyadditions.api.laser.LaserType;
import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.data.WorldData;
import de.ellpeck.actuallyadditions.mod.misc.apiimpl.ConnectionPair;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelay;
import io.netty.util.internal.ConcurrentSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class LaserRelayConnectionHandler
implements ILaserRelayConnectionHandler {
    public static NBTTagCompound writeNetworkToNBT(Network network) {
        NBTTagList list = new NBTTagList();
        for (IConnectionPair pair : network.connections) {
            NBTTagCompound tag = new NBTTagCompound();
            pair.writeToNBT(tag);
            list.func_74742_a((NBTBase)tag);
        }
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("Network", (NBTBase)list);
        return compound;
    }

    public static Network readNetworkFromNBT(NBTTagCompound tag) {
        NBTTagList list = tag.func_150295_c("Network", 10);
        Network network = new Network();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ConnectionPair pair = new ConnectionPair();
            pair.readFromNBT(list.func_150305_b(i));
            network.connections.add((Object)pair);
        }
        return network;
    }

    private static void mergeNetworks(Network firstNetwork, Network secondNetwork, World world) {
        for (IConnectionPair secondPair : secondNetwork.connections) {
            firstNetwork.connections.add((Object)secondPair);
        }
        WorldData data = WorldData.get(world);
        ++secondNetwork.changeAmount;
        data.laserRelayNetworks.remove((Object)secondNetwork);
        data.func_76185_a();
    }

    @Override
    public ConcurrentSet<IConnectionPair> getConnectionsFor(BlockPos relay, World world) {
        ConcurrentSet allPairs = new ConcurrentSet();
        for (Network aNetwork : WorldData.get((World)world).laserRelayNetworks) {
            for (IConnectionPair pair : aNetwork.connections) {
                if (!pair.contains(relay)) continue;
                allPairs.add((Object)pair);
            }
        }
        return allPairs;
    }

    @Override
    public void removeRelayFromNetwork(BlockPos relay, World world) {
        Network network = this.getNetworkFor(relay, world);
        if (network != null) {
            ++network.changeAmount;
            WorldData data = WorldData.get(world);
            data.laserRelayNetworks.remove((Object)network);
            data.func_76185_a();
            for (IConnectionPair pair : network.connections) {
                if (pair.contains(relay)) continue;
                this.addConnection(pair.getPositions()[0], pair.getPositions()[1], pair.getType(), world, pair.doesSuppressRender());
            }
        }
    }

    @Override
    public Network getNetworkFor(BlockPos relay, World world) {
        if (world != null) {
            for (Network aNetwork : WorldData.get((World)world).laserRelayNetworks) {
                for (IConnectionPair pair : aNetwork.connections) {
                    if (!pair.contains(relay)) continue;
                    return aNetwork;
                }
            }
        }
        return null;
    }

    @Override
    public boolean addConnection(BlockPos firstRelay, BlockPos secondRelay, LaserType type, World world) {
        return this.addConnection(firstRelay, secondRelay, type, world, false);
    }

    @Override
    public boolean addConnection(BlockPos firstRelay, BlockPos secondRelay, LaserType type, World world, boolean suppressConnectionRender) {
        return this.addConnection(firstRelay, secondRelay, type, world, suppressConnectionRender, false);
    }

    @Override
    public boolean addConnection(BlockPos firstRelay, BlockPos secondRelay, LaserType type, World world, boolean suppressConnectionRender, boolean removeIfConnected) {
        if (firstRelay == null || secondRelay == null || firstRelay == secondRelay || firstRelay.equals((Object)secondRelay)) {
            return false;
        }
        WorldData data = WorldData.get(world);
        Network firstNetwork = this.getNetworkFor(firstRelay, world);
        Network secondNetwork = this.getNetworkFor(secondRelay, world);
        if (firstNetwork == null && secondNetwork == null) {
            firstNetwork = new Network();
            data.laserRelayNetworks.add((Object)firstNetwork);
            firstNetwork.connections.add((Object)new ConnectionPair(firstRelay, secondRelay, type, suppressConnectionRender));
            ++firstNetwork.changeAmount;
        } else {
            if (firstNetwork == secondNetwork) {
                if (removeIfConnected) {
                    this.removeConnection(world, firstRelay, secondRelay);
                    return true;
                }
                return false;
            }
            if (firstNetwork != null && secondNetwork != null) {
                LaserRelayConnectionHandler.mergeNetworks(firstNetwork, secondNetwork, world);
                firstNetwork.connections.add((Object)new ConnectionPair(firstRelay, secondRelay, type, suppressConnectionRender));
                ++firstNetwork.changeAmount;
            } else if (firstNetwork != null) {
                firstNetwork.connections.add((Object)new ConnectionPair(firstRelay, secondRelay, type, suppressConnectionRender));
                ++firstNetwork.changeAmount;
            } else {
                secondNetwork.connections.add((Object)new ConnectionPair(firstRelay, secondRelay, type, suppressConnectionRender));
                ++secondNetwork.changeAmount;
            }
        }
        data.func_76185_a();
        return true;
    }

    @Override
    public void removeConnection(World world, BlockPos firstRelay, BlockPos secondRelay) {
        Network network;
        if (world != null && firstRelay != null && secondRelay != null && (network = this.getNetworkFor(firstRelay, world)) != null) {
            ++network.changeAmount;
            WorldData data = WorldData.get(world);
            data.laserRelayNetworks.remove((Object)network);
            data.func_76185_a();
            for (IConnectionPair pair : network.connections) {
                if (pair.contains(firstRelay) && pair.contains(secondRelay)) continue;
                this.addConnection(pair.getPositions()[0], pair.getPositions()[1], pair.getType(), world, pair.doesSuppressRender());
            }
        }
    }

    @Override
    public LaserType getTypeFromLaser(TileEntity tile) {
        if (tile instanceof TileEntityLaserRelay) {
            return ((TileEntityLaserRelay)tile).type;
        }
        return null;
    }

    @Override
    public LaserType getTypeFromLaser(BlockPos pos, World world) {
        return this.getTypeFromLaser(world.func_175625_s(pos));
    }
}

