/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import com.google.common.collect.Sets;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigStringListValues;
import de.ellpeck.actuallyadditions.mod.items.base.ItemToolAA;
import de.ellpeck.actuallyadditions.mod.util.IColorProvidingItem;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAllToolAA
extends ItemToolAA
implements IColorProvidingItem {
    public final int color;

    public ItemAllToolAA(Item.ToolMaterial toolMat, String repairItem, String unlocalizedName, EnumRarity rarity, int color) {
        super(4.0f, -2.0f, toolMat, repairItem, unlocalizedName, rarity, new HashSet<Block>());
        this.color = color;
        this.func_77656_e(toolMat.func_77997_a() * 4);
        this.setHarvestLevels(toolMat.func_77996_d());
    }

    public ItemAllToolAA(Item.ToolMaterial toolMat, ItemStack repairItem, String unlocalizedName, EnumRarity rarity, int color) {
        super(4.0f, -2.0f, toolMat, repairItem, unlocalizedName, rarity, new HashSet<Block>());
        this.color = color;
        this.func_77656_e(toolMat.func_77997_a() * 4);
        this.setHarvestLevels(toolMat.func_77996_d());
    }

    private void setHarvestLevels(int amount) {
        for (String s : this.getToolClasses(null)) {
            this.setHarvestLevel(s, amount);
        }
    }

    @Override
    protected void registerRendering() {
        ActuallyAdditions.PROXY.addRenderRegister(new ItemStack((Item)this), new ResourceLocation("actuallyadditions", "item_paxel"), "inventory");
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!playerIn.func_70093_af()) {
            return Items.field_151019_K.func_180614_a(playerIn, worldIn, pos, hand, side, hitX, hitY, hitZ);
        }
        return Items.field_151037_a.func_180614_a(playerIn, worldIn, pos, hand, side, hitX, hitY, hitZ);
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return this.hasExtraWhitelist(state.func_177230_c()) || state.func_185904_a().func_76229_l() || state.func_177230_c() == Blocks.field_150431_aC || state.func_177230_c() == Blocks.field_150433_aE || (state.func_177230_c() == Blocks.field_150343_Z ? this.field_77862_b.func_77996_d() >= 3 : (state.func_177230_c() != Blocks.field_150484_ah && state.func_177230_c() != Blocks.field_150482_ag ? (state.func_177230_c() != Blocks.field_150412_bA && state.func_177230_c() != Blocks.field_150475_bE ? (state.func_177230_c() != Blocks.field_150340_R && state.func_177230_c() != Blocks.field_150352_o ? (state.func_177230_c() != Blocks.field_150339_S && state.func_177230_c() != Blocks.field_150366_p ? (state.func_177230_c() != Blocks.field_150368_y && state.func_177230_c() != Blocks.field_150369_x ? (state.func_177230_c() != Blocks.field_150450_ax && state.func_177230_c() != Blocks.field_150439_ay ? state.func_185904_a() == Material.field_151576_e || state.func_185904_a() == Material.field_151573_f || state.func_185904_a() == Material.field_151574_g : this.field_77862_b.func_77996_d() >= 2) : this.field_77862_b.func_77996_d() >= 1) : this.field_77862_b.func_77996_d() >= 1) : this.field_77862_b.func_77996_d() >= 2) : this.field_77862_b.func_77996_d() >= 2) : this.field_77862_b.func_77996_d() >= 2));
    }

    private boolean hasExtraWhitelist(Block block) {
        String name = block.getRegistryName().toString();
        for (String list : ConfigStringListValues.PAXEL_EXTRA_MINING_WHITELIST.getValue()) {
            if (!list.equals(name)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return Sets.newHashSet((Object[])new String[]{"pickaxe", "axe", "shovel"});
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (state.func_177230_c() == Blocks.field_150321_G) {
            return 15.0f;
        }
        return this.hasExtraWhitelist(state.func_177230_c()) || state.func_177230_c().getHarvestTool(state) == null || state.func_177230_c().getHarvestTool(state).isEmpty() || this.getToolClasses(stack).contains(state.func_177230_c().getHarvestTool(state)) ? this.field_77864_a : 1.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return (stack, pass) -> pass > 0 ? this.color : 0xFFFFFF;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment.field_77351_y.func_77557_a(Items.field_151048_u);
    }
}

